/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.excore.utils.nbt;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public abstract class AdvancedNBTMapUtil<M extends Map<K, V>, N extends NBTBase, K, V, KN extends NBTBase, VN extends NBTBase> {
    public static final String DEFAULTKEYNAME = "key";
    public static final String DEFAULTVALUENAME = "value";
    private String keyName;
    private String valueName;

    public AdvancedNBTMapUtil(String keyName, String valueName) {
        this.keyName = keyName;
        this.valueName = valueName;
    }

    public AdvancedNBTMapUtil() {
        this(DEFAULTKEYNAME, DEFAULTVALUENAME);
    }

    public abstract M newMap();

    public abstract N fromList(NBTTagList var1);

    public abstract NBTTagList toList(N var1);

    public abstract KN keyToNBT(K var1);

    public abstract VN valueToNBT(V var1);

    public abstract K nbtToKey(KN var1);

    public abstract V nbtToValue(VN var1);

    public N toNbt(M map) {
        NBTTagList list = new NBTTagList();
        for (Map.Entry entry : map.entrySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74782_a(this.keyName, this.keyToNBT(entry.getKey()));
            tag.func_74782_a(this.valueName, this.valueToNBT(entry.getValue()));
            list.func_74742_a((NBTBase)tag);
        }
        return this.fromList(list);
    }

    public M fromNbt(N nbt) {
        return this.populate(this.newMap(), nbt);
    }

    public M populate(M map, N nbt) {
        NBTTagList list = this.toList(nbt);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            map.put(this.nbtToKey(tag.func_74781_a(this.keyName)), this.nbtToValue(tag.func_74781_a(this.valueName)));
        }
        return map;
    }

    public static class SimplifiedFunctionDefinedAdvancedNBTMapUtil<M extends Map<K, V>, K, V, KN extends NBTBase, VN extends NBTBase>
    extends SimplifiedAdvancedNBTMapUtil<M, K, V, KN, VN> {
        private Supplier<M> mapSupplier;
        private Function<K, KN> keyToNBT;
        private Function<V, VN> valueToNBT;
        private Function<KN, K> nbtToKey;
        private Function<VN, V> nbtToValue;

        public SimplifiedFunctionDefinedAdvancedNBTMapUtil(Supplier<M> mapSupplier, Function<K, KN> keyToNbt, Function<V, VN> valueToNbt, Function<KN, K> nbtToKey, Function<VN, V> nbtToValue, String keyName, String valueName) {
            super(keyName, valueName);
            this.mapSupplier = mapSupplier;
            this.keyToNBT = keyToNbt;
            this.valueToNBT = valueToNbt;
            this.nbtToKey = nbtToKey;
            this.nbtToValue = nbtToValue;
        }

        @Override
        public M newMap() {
            return (M)((Map)this.mapSupplier.get());
        }

        @Override
        public KN keyToNBT(K key) {
            return (KN)((NBTBase)this.keyToNBT.apply(key));
        }

        @Override
        public VN valueToNBT(V value) {
            return (VN)((NBTBase)this.valueToNBT.apply(value));
        }

        @Override
        public K nbtToKey(KN nbt) {
            return (K)this.nbtToKey.apply(nbt);
        }

        @Override
        public V nbtToValue(VN nbt) {
            return (V)this.nbtToValue.apply(nbt);
        }
    }

    public static class FunctionDefinedAdvancedNBTMapUtil<M extends Map<K, V>, N extends NBTBase, K, V, KN extends NBTBase, VN extends NBTBase>
    extends AdvancedNBTMapUtil<M, N, K, V, KN, VN> {
        private Supplier<M> mapSupplier;
        private Function<NBTTagList, N> fromList;
        private Function<N, NBTTagList> toList;
        private Function<K, KN> keyToNBT;
        private Function<V, VN> valueToNBT;
        private Function<KN, K> nbtToKey;
        private Function<VN, V> nbtToValue;

        public FunctionDefinedAdvancedNBTMapUtil(Supplier<M> mapSupplier, Function<NBTTagList, N> fromList, Function<N, NBTTagList> toList, Function<K, KN> keyToNbt, Function<V, VN> valueToNbt, Function<KN, K> nbtToKey, Function<VN, V> nbtToValue, String keyName, String valueName) {
            super(keyName, valueName);
            this.mapSupplier = mapSupplier;
            this.fromList = fromList;
            this.toList = toList;
            this.keyToNBT = keyToNbt;
            this.valueToNBT = valueToNbt;
            this.nbtToKey = nbtToKey;
            this.nbtToValue = nbtToValue;
        }

        @Override
        public M newMap() {
            return (M)((Map)this.mapSupplier.get());
        }

        @Override
        public N fromList(NBTTagList list) {
            return (N)((NBTBase)this.fromList.apply((Object)list));
        }

        @Override
        public NBTTagList toList(N n) {
            return (NBTTagList)this.toList.apply(n);
        }

        @Override
        public KN keyToNBT(K key) {
            return (KN)((NBTBase)this.keyToNBT.apply(key));
        }

        @Override
        public VN valueToNBT(V value) {
            return (VN)((NBTBase)this.valueToNBT.apply(value));
        }

        @Override
        public K nbtToKey(KN nbt) {
            return (K)this.nbtToKey.apply(nbt);
        }

        @Override
        public V nbtToValue(VN nbt) {
            return (V)this.nbtToValue.apply(nbt);
        }
    }

    public static abstract class SimplifiedAdvancedNBTMapUtil<M extends Map<K, V>, K, V, KN extends NBTBase, VN extends NBTBase>
    extends AdvancedNBTMapUtil<M, NBTTagList, K, V, KN, VN> {
        public SimplifiedAdvancedNBTMapUtil(String keyName, String valueName) {
            super(keyName, valueName);
        }

        public SimplifiedAdvancedNBTMapUtil() {
        }

        @Override
        public NBTTagList fromList(NBTTagList list) {
            return list;
        }

        @Override
        public NBTTagList toList(NBTTagList list) {
            return list;
        }
    }
}

