/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.excore.utils.color;

import code.elix_x.excore.utils.color.IColor;
import code.elix_x.excore.utils.color.RGBA;
import net.minecraft.nbt.NBTTagCompound;

public class HSBA
implements IColor {
    public float hue;
    public float saturation;
    public float brightness;
    public float alpha;

    private HSBA() {
    }

    public HSBA(float hue, float saturation, float brightness, float alpha) {
        this.hue = hue;
        this.saturation = saturation;
        this.brightness = brightness;
        this.alpha = alpha;
    }

    public HSBA(float hue, float saturation, float brightness) {
        this(hue, saturation, brightness, 1.0f);
    }

    @Override
    public RGBA toRGBA() {
        byte red = 0;
        byte green = 0;
        byte blue = 0;
        if (this.saturation == 0.0f) {
            green = blue = (byte)(this.brightness * 255.0f + 0.5f);
            red = blue;
        } else {
            float f3 = (this.hue - (float)Math.floor(this.hue)) * 6.0f;
            float f4 = f3 - (float)Math.floor(f3);
            float f5 = this.brightness * (1.0f - this.saturation);
            float f6 = this.brightness * (1.0f - this.saturation * f4);
            float f7 = this.brightness * (1.0f - this.saturation * (1.0f - f4));
            switch ((int)f3) {
                case 0: {
                    red = (byte)(this.brightness * 255.0f + 0.5f);
                    green = (byte)(f7 * 255.0f + 0.5f);
                    blue = (byte)(f5 * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    red = (byte)(f6 * 255.0f + 0.5f);
                    green = (byte)(this.brightness * 255.0f + 0.5f);
                    blue = (byte)(f5 * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    red = (byte)(f5 * 255.0f + 0.5f);
                    green = (byte)(this.brightness * 255.0f + 0.5f);
                    blue = (byte)(f7 * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    red = (byte)(f5 * 255.0f + 0.5f);
                    green = (byte)(f6 * 255.0f + 0.5f);
                    blue = (byte)(this.brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    red = (byte)(f7 * 255.0f + 0.5f);
                    green = (byte)(f5 * 255.0f + 0.5f);
                    blue = (byte)(this.brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    red = (byte)(this.brightness * 255.0f + 0.5f);
                    green = (byte)(f5 * 255.0f + 0.5f);
                    blue = (byte)(f6 * 255.0f + 0.5f);
                }
            }
        }
        return new RGBA(red, green, blue, (int)(this.alpha * 255.0f));
    }

    @Override
    public HSBA toHSBA() {
        return this;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74776_a("h", this.hue);
        nbt.func_74776_a("s", this.saturation);
        nbt.func_74776_a("b", this.brightness);
        nbt.func_74776_a("a", this.alpha);
        return nbt;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.hue = nbt.func_74760_g("h");
        this.saturation = nbt.func_74760_g("s");
        this.brightness = nbt.func_74760_g("b");
        this.alpha = nbt.func_74760_g("a");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.alpha);
        result = 31 * result + Float.floatToIntBits(this.brightness);
        result = 31 * result + Float.floatToIntBits(this.hue);
        result = 31 * result + Float.floatToIntBits(this.saturation);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HSBA other = (HSBA)obj;
        if (Float.floatToIntBits(this.alpha) != Float.floatToIntBits(other.alpha)) {
            return false;
        }
        if (Float.floatToIntBits(this.brightness) != Float.floatToIntBits(other.brightness)) {
            return false;
        }
        if (Float.floatToIntBits(this.hue) != Float.floatToIntBits(other.hue)) {
            return false;
        }
        return Float.floatToIntBits(this.saturation) == Float.floatToIntBits(other.saturation);
    }

    public String toString() {
        return "HSBA [hue=" + this.hue + ", saturation=" + this.saturation + ", brightness=" + this.brightness + ", alpha=" + this.alpha + "]";
    }
}

