/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.excore.utils.client.cursor;

import com.google.common.base.Throwables;
import java.awt.image.BufferedImage;
import java.nio.IntBuffer;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Cursor;
import org.lwjgl.input.Mouse;

public class CursorHelper {
    public static final Cursor defaultCursor = Mouse.getNativeCursor();

    public static Cursor createCursor(ResourceLocation texture) {
        try {
            BufferedImage image = ImageIO.read(Minecraft.func_71410_x().func_110442_L().func_110536_a(texture).func_110527_b());
            return new Cursor(image.getWidth(), image.getHeight(), image.getWidth() / 2, image.getHeight() / 2, 1, IntBuffer.wrap(image.getRGB(0, 0, image.getWidth(), image.getHeight(), null, 0, image.getWidth())), null);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static Cursor createCursor(ResourceLocation texture, int hotSpotX, int hotSpotY) {
        try {
            BufferedImage image = ImageIO.read(Minecraft.func_71410_x().func_110442_L().func_110536_a(texture).func_110527_b());
            return new Cursor(image.getWidth(), image.getHeight(), hotSpotX, hotSpotY, 1, IntBuffer.wrap(image.getRGB(0, 0, image.getWidth(), image.getHeight(), null, 0, image.getWidth())), null);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static void setCursor(Cursor cursor) {
        try {
            Mouse.setNativeCursor((Cursor)cursor);
        }
        catch (LWJGLException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    public static void resetCursor() {
        CursorHelper.setCursor(defaultCursor);
    }
}

