/*
 * Decompiled with CFR 0.152.
 */
package com.zerofall.ezstorage.util;

import com.zerofall.ezstorage.util.ItemGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;

public class EZInventory {
    public List<ItemGroup> inventory = new ArrayList<ItemGroup>();
    public long maxItems = 0L;

    public ItemStack input(ItemStack itemStack) {
        if (this.getTotalCount() >= this.maxItems) {
            return itemStack;
        }
        long space = this.maxItems - this.getTotalCount();
        int amount = (int)Math.min(space, (long)itemStack.field_77994_a);
        return this.mergeStack(itemStack, amount);
    }

    public void sort() {
        Collections.sort(this.inventory, new ItemGroup.CountComparator());
    }

    private ItemStack mergeStack(ItemStack itemStack, int amount) {
        for (ItemGroup group : this.inventory) {
            if (!EZInventory.stacksEqual(group.itemStack, itemStack)) continue;
            group.count += (long)amount;
            itemStack.field_77994_a -= amount;
            if (itemStack.field_77994_a <= 0) {
                return null;
            }
            return itemStack;
        }
        this.inventory.add(new ItemGroup(itemStack, amount));
        itemStack.field_77994_a -= amount;
        if (itemStack.field_77994_a <= 0) {
            return null;
        }
        return itemStack;
    }

    public ItemStack getItemsAt(int index, int type) {
        if (index >= this.inventory.size()) {
            return null;
        }
        ItemGroup group = this.inventory.get(index);
        ItemStack stack = group.itemStack.func_77946_l();
        int size = (int)Math.min((long)stack.func_77976_d(), group.count);
        if (size > 1) {
            if (type == 1) {
                size /= 2;
            } else if (type == 2) {
                size = 1;
            }
        }
        stack.field_77994_a = size;
        group.count -= (long)size;
        if (group.count <= 0L) {
            this.inventory.remove(index);
        }
        return stack;
    }

    public ItemStack getItems(ItemStack[] itemStacks) {
        for (ItemGroup group : this.inventory) {
            for (ItemStack itemStack : itemStacks) {
                if (!EZInventory.stacksEqual(group.itemStack, itemStack)) continue;
                if (group.count >= (long)itemStack.field_77994_a) {
                    ItemStack stack = group.itemStack.func_77946_l();
                    stack.field_77994_a = itemStack.field_77994_a;
                    group.count -= (long)itemStack.field_77994_a;
                    if (group.count <= 0L) {
                        this.inventory.remove(group);
                    }
                    return stack;
                }
                return null;
            }
        }
        return null;
    }

    public int slotCount() {
        return this.inventory.size();
    }

    public static boolean stacksEqual(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null && stack2 == null) {
            return true;
        }
        if (stack1 == null || stack2 == null) {
            return false;
        }
        return stack1.func_77973_b() == stack2.func_77973_b() && stack1.func_77952_i() == stack2.func_77952_i() && stack1.func_77978_p() == stack2.func_77978_p();
    }

    public long getTotalCount() {
        long count = 0L;
        for (ItemGroup group : this.inventory) {
            count += group.count;
        }
        return count;
    }

    public String toString() {
        return this.inventory.toString();
    }
}

