/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.ironchest;

import cpw.mods.ironchest.BlockIronChest;
import cpw.mods.ironchest.ChestChangerType;
import cpw.mods.ironchest.CommonProxy;
import cpw.mods.ironchest.IronChestType;
import cpw.mods.ironchest.ItemIronChest;
import cpw.mods.ironchest.OcelotsSitOnChestsHandler;
import cpw.mods.ironchest.Version;
import net.minecraft.block.Block;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;

@Mod(modid="IronChest", name="Iron Chests", dependencies="required-after:Forge@[11.15.0,12.0]", acceptedMinecraftVersions="[1.8,1.8.9]")
public class IronChest {
    public static BlockIronChest ironChestBlock;
    @SidedProxy(clientSide="cpw.mods.ironchest.client.ClientProxy", serverSide="cpw.mods.ironchest.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="IronChest")
    public static IronChest instance;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Version.init(event.getVersionProperties());
        event.getModMetadata().version = Version.fullVersionString();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent evt) {
        ChestChangerType.buildItems();
        ironChestBlock = new BlockIronChest();
        GameRegistry.registerBlock((Block)ironChestBlock, ItemIronChest.class, (String)"BlockIronChest");
        for (IronChestType typ : IronChestType.values()) {
            GameRegistry.registerTileEntityWithAlternatives(typ.clazz, (String)("IronChest." + typ.name()), (String[])new String[]{typ.name()});
            proxy.registerTileEntitySpecialRenderer(typ.clazz);
        }
        IronChestType.registerBlocksAndRecipes(ironChestBlock);
        ChestChangerType.generateRecipes();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)proxy);
        proxy.registerRenderInformation();
        MinecraftForge.EVENT_BUS.register((Object)new OcelotsSitOnChestsHandler());
    }
}

