/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.util;

import mezz.jei.api.gui.ITickTimer;
import mezz.jei.util.MathUtil;
import net.minecraft.client.Minecraft;

public class TickTimer
implements ITickTimer {
    private final int ticksPerCycle;
    private final int maxValue;
    private final boolean countDown;
    private long lastUpdateWorldTime = 0L;
    private int tickCount = 0;

    public TickTimer(int ticksPerCycle, int maxValue, boolean countDown) {
        this.ticksPerCycle = ticksPerCycle;
        this.maxValue = maxValue;
        this.countDown = countDown;
    }

    @Override
    public int getValue() {
        long worldTime = Minecraft.func_71410_x().field_71441_e.func_82737_E();
        long ticksPassed = worldTime - this.lastUpdateWorldTime;
        this.lastUpdateWorldTime = worldTime;
        this.tickCount = (int)((long)this.tickCount + ticksPassed);
        if (this.tickCount > this.ticksPerCycle) {
            this.tickCount = 0;
        }
        int value = MathUtil.divideCeil(this.tickCount * this.maxValue, this.ticksPerCycle);
        if (this.countDown) {
            return this.maxValue - value;
        }
        return value;
    }

    @Override
    public int getMaxValue() {
        return this.maxValue;
    }
}

