/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.furnace;

import java.awt.Color;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.plugins.vanilla.VanillaRecipeWrapper;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;

public class SmeltingRecipe
extends VanillaRecipeWrapper {
    @Nonnull
    private final List<List<ItemStack>> input;
    @Nonnull
    private final List<ItemStack> outputs;
    @Nullable
    private final String experienceString;

    public SmeltingRecipe(@Nonnull List<ItemStack> input, @Nonnull ItemStack output, float experience) {
        this.input = Collections.singletonList(input);
        this.outputs = Collections.singletonList(output);
        this.experienceString = (double)experience > 0.0 ? Translator.translateToLocalFormatted("gui.jei.category.smelting.experience", Float.valueOf(experience)) : null;
    }

    @Override
    @Nonnull
    public List<List<ItemStack>> getInputs() {
        return this.input;
    }

    @Override
    @Nonnull
    public List<ItemStack> getOutputs() {
        return this.outputs;
    }

    @Override
    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        if (this.experienceString != null) {
            FontRenderer fontRendererObj = minecraft.field_71466_p;
            int stringWidth = fontRendererObj.func_78256_a(this.experienceString);
            fontRendererObj.func_78276_b(this.experienceString, recipeWidth - stringWidth, 0, Color.gray.getRGB());
        }
    }
}

