/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.brewing;

import javax.annotation.Nonnull;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.plugins.vanilla.brewing.BrewingRecipeWrapper;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.Log;

public class BrewingRecipeHandler
implements IRecipeHandler<BrewingRecipeWrapper> {
    @Override
    @Nonnull
    public Class<BrewingRecipeWrapper> getRecipeClass() {
        return BrewingRecipeWrapper.class;
    }

    @Override
    @Nonnull
    public String getRecipeCategoryUid() {
        return "minecraft.brewing";
    }

    @Override
    @Nonnull
    public IRecipeWrapper getRecipeWrapper(@Nonnull BrewingRecipeWrapper recipe) {
        return recipe;
    }

    @Override
    public boolean isRecipeValid(@Nonnull BrewingRecipeWrapper recipe) {
        String recipeInfo;
        if (recipe.getInputs().size() != 4) {
            recipeInfo = ErrorUtil.getInfoFromBrokenRecipe(recipe, this);
            Log.error("Recipe has the wrong number of inputs (needs 4). {}", recipeInfo);
        }
        if (recipe.getOutputs().size() != 1) {
            recipeInfo = ErrorUtil.getInfoFromBrokenRecipe(recipe, this);
            Log.error("Recipe has the wrong number of outputs (needs 1). {}", recipeInfo);
        }
        return true;
    }
}

