/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.ingredients;

import com.google.common.base.Joiner;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.config.Config;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.pipeline.LightUtil;

public class GuiItemStackFast {
    private static final ResourceLocation RES_ITEM_GLINT = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    private static final int blacklistItemColor = Color.yellow.getRGB();
    private static final int blacklistWildColor = Color.red.getRGB();
    private static final int blacklistModColor = Color.blue.getRGB();
    @Nonnull
    private final Rectangle area;
    private final int padding;
    private final ItemModelMesher itemModelMesher;
    @Nullable
    private ItemStack itemStack;

    public GuiItemStackFast(int xPosition, int yPosition, int padding) {
        this.padding = padding;
        int size = 16 + 2 * padding;
        this.area = new Rectangle(xPosition, yPosition, size, size);
        this.itemModelMesher = Minecraft.func_71410_x().func_175599_af().func_175037_a();
    }

    @Nonnull
    public Rectangle getArea() {
        return this.area;
    }

    public void setItemStack(@Nonnull ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    @Nullable
    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public void clear() {
        this.itemStack = null;
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        return this.itemStack != null && this.area.contains(mouseX, mouseY);
    }

    public void renderItemAndEffectIntoGUI() {
        if (this.itemStack == null) {
            return;
        }
        IBakedModel bakedModel = this.itemModelMesher.func_178089_a(this.itemStack);
        GlStateManager.func_179094_E();
        int x = this.area.x + this.padding + 8;
        int y = this.area.y + this.padding + 8;
        if (bakedModel.func_177556_c()) {
            if (Config.isEditModeEnabled()) {
                GlStateManager.func_179139_a((double)0.05, (double)0.05, (double)-0.05);
                this.renderEditMode();
                GlStateManager.func_179147_l();
                GlStateManager.func_179152_a((float)20.0f, (float)20.0f, (float)-20.0f);
            }
            GlStateManager.func_179109_b((float)((float)x / 20.0f), (float)((float)y / 20.0f), (float)-7.5f);
            GlStateManager.func_179114_b((float)210.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        } else {
            if (Config.isEditModeEnabled()) {
                GlStateManager.func_179139_a((double)0.03125, (double)0.03125, (double)-0.03125);
                this.renderEditMode();
                GlStateManager.func_179147_l();
                GlStateManager.func_179152_a((float)32.0f, (float)32.0f, (float)-32.0f);
            }
            GlStateManager.func_179109_b((float)((float)x / 32.0f), (float)((float)y / 32.0f), (float)-4.6875f);
            GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        bakedModel = ForgeHooksClient.handleCameraTransforms((IBakedModel)bakedModel, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.GUI);
        GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
        this.renderModel(bakedModel, this.itemStack);
        if (this.itemStack.func_77962_s()) {
            this.renderEffect(bakedModel);
        }
        GlStateManager.func_179121_F();
    }

    private void renderModel(IBakedModel model, ItemStack stack) {
        this.renderModel(model, -1, stack);
    }

    private void renderModel(IBakedModel model, int color, ItemStack stack) {
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        for (EnumFacing enumfacing : EnumFacing.field_82609_l) {
            this.renderQuads(worldrenderer, model.func_177551_a(enumfacing), color, stack);
        }
        this.renderQuads(worldrenderer, model.func_177550_a(), color, stack);
        tessellator.func_78381_a();
    }

    private void renderQuads(WorldRenderer renderer, List quads, int color, ItemStack stack) {
        boolean flag = color == -1 && stack != null;
        for (Object quad : quads) {
            BakedQuad bakedquad = (BakedQuad)quad;
            int j = color;
            if (flag && bakedquad.func_178212_b()) {
                j = stack.func_77973_b().func_82790_a(stack, bakedquad.func_178211_c());
                if (EntityRenderer.field_78517_a) {
                    j = TextureUtil.func_177054_c((int)j);
                }
                j |= 0xFF000000;
            }
            LightUtil.renderQuadColor((WorldRenderer)renderer, (BakedQuad)bakedquad, (int)j);
        }
    }

    private void renderEffect(IBakedModel model) {
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179143_c((int)514);
        GlStateManager.func_179112_b((int)768, (int)1);
        textureManager.func_110577_a(RES_ITEM_GLINT);
        GlStateManager.func_179128_n((int)5890);
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)8.0f);
        float f = (float)(Minecraft.func_71386_F() % 3000L) / 3000.0f / 8.0f;
        GlStateManager.func_179109_b((float)f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.renderModel(model, -8372020);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)8.0f);
        float f1 = (float)(Minecraft.func_71386_F() % 4873L) / 4873.0f / 8.0f;
        GlStateManager.func_179109_b((float)(-f1), (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.renderModel(model, -8372020);
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179132_a((boolean)true);
        textureManager.func_110577_a(TextureMap.field_110575_b);
    }

    private void renderModel(IBakedModel model, int color) {
        this.renderModel(model, color, null);
    }

    public void renderSlow() {
        if (Config.isEditModeEnabled()) {
            this.renderEditMode();
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        RenderItem renderItem = minecraft.func_175599_af();
        renderItem.func_180450_b(this.itemStack, this.area.x + this.padding, this.area.y + this.padding);
        GlStateManager.func_179084_k();
    }

    public void renderOverlay(Minecraft minecraft) {
        if (this.itemStack == null) {
            return;
        }
        FontRenderer font = GuiItemStackFast.getFontRenderer(minecraft, this.itemStack);
        RenderItem renderItem = minecraft.func_175599_af();
        renderItem.func_180453_a(font, this.itemStack, this.area.x + this.padding, this.area.y + this.padding, null);
    }

    private void renderEditMode() {
        if (this.itemStack == null) {
            return;
        }
        if (Config.isItemOnConfigBlacklist(this.itemStack, Config.ItemBlacklistType.ITEM)) {
            GuiScreen.func_73734_a((int)(this.area.x + this.padding), (int)(this.area.y + this.padding), (int)(this.area.x + 8 + this.padding), (int)(this.area.y + 16 + this.padding), (int)blacklistItemColor);
        }
        if (Config.isItemOnConfigBlacklist(this.itemStack, Config.ItemBlacklistType.WILDCARD)) {
            GuiScreen.func_73734_a((int)(this.area.x + 8 + this.padding), (int)(this.area.y + this.padding), (int)(this.area.x + 16 + this.padding), (int)(this.area.y + 16 + this.padding), (int)blacklistWildColor);
        }
        if (Config.isItemOnConfigBlacklist(this.itemStack, Config.ItemBlacklistType.MOD_ID)) {
            GuiScreen.func_73734_a((int)(this.area.x + this.padding), (int)(this.area.y + 8 + this.padding), (int)(this.area.x + 16 + this.padding), (int)(this.area.y + 16 + this.padding), (int)blacklistModColor);
        }
    }

    @Nonnull
    public static FontRenderer getFontRenderer(@Nonnull Minecraft minecraft, @Nonnull ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        FontRenderer fontRenderer = item.getFontRenderer(itemStack);
        if (fontRenderer == null) {
            fontRenderer = minecraft.field_71466_p;
        }
        return fontRenderer;
    }

    public void drawHovered(Minecraft minecraft) {
        if (this.itemStack == null) {
            return;
        }
        this.renderSlow();
        this.renderOverlay(minecraft);
        GlStateManager.func_179097_i();
        Gui.func_73734_a((int)this.area.x, (int)this.area.y, (int)(this.area.x + this.area.width), (int)(this.area.y + this.area.height), (int)Integer.MAX_VALUE);
        GlStateManager.func_179126_j();
    }

    public void drawTooltip(@Nonnull Minecraft minecraft, int mouseX, int mouseY) {
        if (this.itemStack == null) {
            return;
        }
        List<String> tooltip = GuiItemStackFast.getTooltip(minecraft, this.itemStack);
        FontRenderer fontRenderer = GuiItemStackFast.getFontRenderer(minecraft, this.itemStack);
        TooltipRenderer.drawHoveringText(minecraft, tooltip, mouseX, mouseY, fontRenderer);
    }

    @Nonnull
    private static List<String> getTooltip(@Nonnull Minecraft minecraft, @Nonnull ItemStack itemStack) {
        Collection<String> colorNames;
        List list = itemStack.func_82840_a((EntityPlayer)minecraft.field_71439_g, minecraft.field_71474_y.field_82882_x);
        for (int k = 0; k < list.size(); ++k) {
            if (k == 0) {
                list.set(k, itemStack.func_77953_t().field_77937_e + (String)list.get(k));
                continue;
            }
            list.set(k, EnumChatFormatting.GRAY + (String)list.get(k));
        }
        int maxWidth = 125;
        for (String tooltipLine : list) {
            int width = minecraft.field_71466_p.func_78256_a(tooltipLine);
            if (width <= maxWidth) continue;
            maxWidth = width;
        }
        if (Config.isColorSearchEnabled() && !(colorNames = Internal.getColorNamer().getColorNames(itemStack)).isEmpty()) {
            String colorNamesString = Joiner.on((String)", ").join(colorNames);
            String colorNamesLocalizedString = EnumChatFormatting.GRAY + Translator.translateToLocalFormatted("jei.tooltip.item.colors", colorNamesString);
            list.addAll(minecraft.field_71466_p.func_78271_c(colorNamesLocalizedString, maxWidth));
        }
        if (Config.isEditModeEnabled()) {
            String description;
            list.add("");
            list.add(EnumChatFormatting.ITALIC + Translator.translateToLocal("gui.jei.editMode.description"));
            if (Config.isItemOnConfigBlacklist(itemStack, Config.ItemBlacklistType.ITEM)) {
                description = EnumChatFormatting.YELLOW + Translator.translateToLocal("gui.jei.editMode.description.show");
                list.addAll(minecraft.field_71466_p.func_78271_c(description, maxWidth));
            } else {
                description = EnumChatFormatting.YELLOW + Translator.translateToLocal("gui.jei.editMode.description.hide");
                list.addAll(minecraft.field_71466_p.func_78271_c(description, maxWidth));
            }
            if (Config.isItemOnConfigBlacklist(itemStack, Config.ItemBlacklistType.WILDCARD)) {
                description = EnumChatFormatting.RED + Translator.translateToLocal("gui.jei.editMode.description.show.wild");
                list.addAll(minecraft.field_71466_p.func_78271_c(description, maxWidth));
            } else {
                description = EnumChatFormatting.RED + Translator.translateToLocal("gui.jei.editMode.description.hide.wild");
                list.addAll(minecraft.field_71466_p.func_78271_c(description, maxWidth));
            }
            if (Config.isItemOnConfigBlacklist(itemStack, Config.ItemBlacklistType.MOD_ID)) {
                description = EnumChatFormatting.BLUE + Translator.translateToLocal("gui.jei.editMode.description.show.mod.id");
                list.addAll(minecraft.field_71466_p.func_78271_c(description, maxWidth));
            } else {
                description = EnumChatFormatting.BLUE + Translator.translateToLocal("gui.jei.editMode.description.hide.mod.id");
                list.addAll(minecraft.field_71466_p.func_78271_c(description, maxWidth));
            }
        }
        return list;
    }
}

