/*
 * Decompiled with CFR 0.152.
 */
package alexndr.api.content.items;

import alexndr.api.content.items.BucketVariant;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;

public class SimpleBucketType {
    private String material;
    private boolean destroyOnLava = false;
    private List<BucketVariant> variantList = Lists.newArrayList();

    public SimpleBucketType(String material) {
        this.material = material;
    }

    public boolean getDestroyOnLava() {
        return this.destroyOnLava;
    }

    public void setDestroyOnLava(boolean destroyOnLava) {
        this.destroyOnLava = destroyOnLava;
    }

    public String getMaterial() {
        return this.material;
    }

    public SimpleBucketType addVariant(String name, Item bucket, Block liquidBlock) {
        BucketVariant variant = new BucketVariant(name, bucket, liquidBlock);
        this.variantList.add(variant);
        return this;
    }

    public List<Block> getLiquidsList() {
        ArrayList liquidList = Lists.newArrayList();
        for (BucketVariant variant : this.variantList) {
            liquidList.add(variant.liquidBlock);
        }
        return liquidList;
    }

    public boolean doesVariantExist(Block liquid) {
        for (BucketVariant variant : this.variantList) {
            if (variant.liquidBlock != liquid) continue;
            return true;
        }
        return false;
    }

    public Item getBucketFromLiquid(Block liquid) {
        for (BucketVariant variant : this.variantList) {
            if (variant.liquidBlock != liquid) continue;
            return variant.bucket;
        }
        return null;
    }
}

