/*
 * Decompiled with CFR 0.152.
 */
package alexndr.api.content.items;

import alexndr.api.config.types.ConfigEntry;
import alexndr.api.content.items.SimpleBowEffects;
import alexndr.api.core.SimpleCoreAPI;
import alexndr.api.helpers.game.TooltipHelper;
import alexndr.api.registry.ContentCategories;
import alexndr.api.registry.ContentRegistry;
import alexndr.api.registry.Plugin;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class SimpleBow
extends ItemBow {
    private Plugin plugin;
    private ContentCategories.Item category = ContentCategories.Item.WEAPON;
    private ConfigEntry entry;
    private List<String> toolTipStrings = Lists.newArrayList();
    private HashMap<SimpleBowEffects, Object> effects = new HashMap();
    private ItemStack repairMaterial;
    private float zoomAmount = 0.165f;

    public SimpleBow(Plugin plugin, int maxUses) {
        this.plugin = plugin;
        this.func_77656_e(maxUses);
        this.field_77789_bW = true;
    }

    public SimpleBow setUnlocalizedName(String bowName) {
        super.func_77655_b(bowName);
        GameRegistry.registerItem((Item)this, (String)bowName);
        SimpleCoreAPI.addBowRenderDetails(this.plugin, (Item)this);
        ContentRegistry.registerItem(this.plugin, (Item)this, bowName, this.category);
        ContentRegistry.registerItem(this.plugin, (Item)this, bowName + "_pulling_0", this.category);
        ContentRegistry.registerItem(this.plugin, (Item)this, bowName + "_pulling_1", this.category);
        ContentRegistry.registerItem(this.plugin, (Item)this, bowName + "_pulling_2", this.category);
        return this;
    }

    public ConfigEntry getConfigEntry() {
        return this.entry;
    }

    public SimpleBow setConfigEntry(ConfigEntry entry) {
        this.entry = entry;
        this.setAdditionalProperties();
        return this;
    }

    public SimpleBow addToolTip(String toolTip) {
        TooltipHelper.addTooltipToItem((Item)this, toolTip);
        return this;
    }

    public SimpleBow addToolTip(String toolTip, EnumChatFormatting color) {
        TooltipHelper.addTooltipToItem((Item)this, color + StatCollector.func_74838_a((String)toolTip));
        return this;
    }

    public SimpleBow setRepairMaterial(ItemStack repairMaterial) {
        this.repairMaterial = repairMaterial;
        return this;
    }

    public SimpleBow setEffect(SimpleBowEffects effect) {
        this.effects.put(effect, null);
        return this;
    }

    public SimpleBow setEffect(SimpleBowEffects effect, float modifier) {
        this.effects.put(effect, Float.valueOf(modifier));
        return this;
    }

    public SimpleBow setEffect(SimpleBowEffects effect, int modifier) {
        this.effects.put(effect, modifier);
        return this;
    }

    public float getZoomAmount() {
        return this.zoomAmount;
    }

    public SimpleBow setZoomAmount(float zoomAmount) {
        this.zoomAmount = zoomAmount;
        return this;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return this.repairMaterial.func_77973_b() == repair.func_77973_b() ? true : super.func_82789_a(toRepair, repair);
    }

    public void func_77615_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer, int par4) {
        boolean infArrows;
        int maxUseDuration = this.func_77626_a(par1ItemStack) - par4;
        ArrowLooseEvent event = new ArrowLooseEvent(par3EntityPlayer, par1ItemStack, maxUseDuration);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return;
        }
        boolean bl = infArrows = par3EntityPlayer.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((int)Enchantment.field_77342_w.field_77352_x, (ItemStack)par1ItemStack) > 0 || this.effects.containsKey(SimpleBowEffects.infiniteArrows);
        if (infArrows || par3EntityPlayer.field_71071_by.func_146028_b(Items.field_151032_g)) {
            float f = (float)maxUseDuration / 20.0f;
            if ((double)(f = (f * f + f * 2.0f) / 3.0f) < 0.1) {
                return;
            }
            if (f > 1.0f) {
                f = 1.0f;
            }
            EntityArrow arrow = new EntityArrow(par2World, (EntityLivingBase)par3EntityPlayer, f * 2.0f);
            int powerLevel = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)par1ItemStack);
            int punchLevel = EnchantmentHelper.func_77506_a((int)Enchantment.field_77344_u.field_77352_x, (ItemStack)par1ItemStack);
            int flameLevel = EnchantmentHelper.func_77506_a((int)Enchantment.field_77343_v.field_77352_x, (ItemStack)par1ItemStack);
            boolean efficient = false;
            if (f == 1.0f) {
                arrow.func_70243_d(true);
            }
            if (powerLevel > 0) {
                arrow.func_70239_b(arrow.func_70242_d() + (double)powerLevel * 0.5 + 0.5);
            }
            if (punchLevel > 0) {
                arrow.func_70240_a(punchLevel);
            }
            if (flameLevel > 0 || this.effects.containsKey(SimpleBowEffects.flameEffect)) {
                arrow.func_70015_d(100);
            }
            if (f == 1.0f && this.effects.containsKey(SimpleBowEffects.critFlameEffect)) {
                arrow.func_70015_d(100);
            }
            if (this.effects.containsKey(SimpleBowEffects.damageEffect)) {
                arrow.func_70239_b(arrow.func_70242_d() * (double)((Float)this.effects.get(SimpleBowEffects.damageEffect)).floatValue());
            }
            if (this.effects.containsKey(SimpleBowEffects.knockbackEffect)) {
                arrow.func_70240_a(punchLevel > 0 ? punchLevel + (Integer)this.effects.get(SimpleBowEffects.knockbackEffect) : (Integer)this.effects.get(SimpleBowEffects.knockbackEffect));
            }
            if (this.effects.containsKey(SimpleBowEffects.efficiencyEffect)) {
                efficient = this.randomChance((Integer)this.effects.get(SimpleBowEffects.efficiencyEffect));
            }
            par1ItemStack.func_77972_a(1, (EntityLivingBase)par3EntityPlayer);
            par2World.func_72956_a((Entity)par3EntityPlayer, "random.bow", 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
            if (infArrows || efficient) {
                arrow.field_70251_a = 2;
            } else {
                par3EntityPlayer.field_71071_by.func_146026_a(Items.field_151032_g);
            }
            if (!par2World.field_72995_K) {
                par2World.func_72838_d((Entity)arrow);
            }
        }
    }

    public boolean randomChance(int chance) {
        Random random = new Random();
        int rand = random.nextInt(100);
        return rand <= chance;
    }

    public ModelResourceLocation getModel(ItemStack stack, EntityPlayer player, int useRemaining) {
        ModelResourceLocation modelresourcelocation = new ModelResourceLocation(this.plugin.getModId() + ":" + this.func_77658_a().substring(5), "inventory");
        int var8 = stack.func_77988_m() - useRemaining;
        if (stack.func_77973_b() == this && player.func_71011_bu() != null) {
            if (var8 >= 18) {
                modelresourcelocation = new ModelResourceLocation(this.plugin.getModId() + ":" + this.func_77658_a().substring(5) + "_pulling_2", "inventory");
            } else if (var8 > 13) {
                modelresourcelocation = new ModelResourceLocation(this.plugin.getModId() + ":" + this.func_77658_a().substring(5) + "_pulling_1", "inventory");
            } else if (var8 > 0) {
                modelresourcelocation = new ModelResourceLocation(this.plugin.getModId() + ":" + this.func_77658_a().substring(5) + "_pulling_0", "inventory");
            }
        }
        return modelresourcelocation;
    }

    public void setAdditionalProperties() {
        if (this.entry.getValueByName("CreativeTab") != null && this.entry.getValueByName("CreativeTab").isActive() && ContentRegistry.doesTabExist(this.entry.getValueByName("CreativeTab").getCurrentValue())) {
            this.func_77637_a(ContentRegistry.getTab(this.entry.getValueByName("CreativeTab").getCurrentValue()));
        }
    }
}

