/*
 * Decompiled with CFR 0.152.
 */
package alexndr.api.config.types;

import alexndr.api.config.types.ConfigEntry;
import alexndr.api.config.types.ConfigValue;
import alexndr.api.logger.LogHelper;
import alexndr.api.registry.ContentRegistry;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;

public class ConfigBlock
extends ConfigEntry {
    private List<ConfigValue> valuesList = Lists.newArrayList();
    private ConfigValue hardness = new ConfigValue("Hardness").setCurrentValue("0.0");
    private ConfigValue resistance = new ConfigValue("Resistance").setCurrentValue("0.0");
    private ConfigValue lightValue = new ConfigValue("LightValue").setCurrentValue("0.0");
    private ConfigValue harvestLevel = new ConfigValue("HarvestLevel").setCurrentValue("0");
    private ConfigValue harvestTool = new ConfigValue("HarvestTool");
    private ConfigValue creativeTab = new ConfigValue("CreativeTab");
    private ConfigValue spawnRate = new ConfigValue("SpawnRate");
    private ConfigValue veinSize = new ConfigValue("VeinSize");
    private ConfigValue minHeight = new ConfigValue("MinHeight");
    private ConfigValue maxHeight = new ConfigValue("MaxHeight");
    private ConfigValue dropItem = new ConfigValue("DropItem").setCurrentValue("false");
    private ConfigValue itemToDrop = new ConfigValue("ItemToDrop");
    private ConfigValue quantityToDrop = new ConfigValue("QuantityToDrop");
    private ConfigValue blockMaterial = new ConfigValue("BlockMaterial").setCurrentValue("rock");
    private ConfigValue soundType = new ConfigValue("SoundType").setCurrentValue("soundTypeStone");
    private ConfigValue unbreakable = new ConfigValue("Unbreakable").setCurrentValue("false");
    private ConfigValue fireSource = new ConfigValue("FireSource").setCurrentValue("false");
    private ConfigValue isLeaves = new ConfigValue("IsLeaves").setCurrentValue("false");
    private ConfigValue isWood = new ConfigValue("IsWood").setCurrentValue("false");
    private ConfigValue beaconBase = new ConfigValue("BeaconBase").setCurrentValue("false");

    public ConfigBlock(String name, String category) {
        super(name, category);
        this.valuesList.addAll(Lists.newArrayList((Object[])new ConfigValue[]{this.hardness, this.resistance, this.lightValue, this.harvestLevel, this.harvestTool, this.creativeTab, this.spawnRate, this.veinSize, this.minHeight, this.maxHeight, this.dropItem, this.itemToDrop, this.quantityToDrop, this.blockMaterial, this.soundType, this.unbreakable, this.fireSource, this.isLeaves, this.isWood, this.beaconBase}));
        super.setValuesList(this.valuesList);
    }

    @Override
    public List<ConfigValue> getValuesList() {
        return this.valuesList;
    }

    @Override
    public void setValuesList(List<ConfigValue> valuesList) {
        this.valuesList = valuesList;
    }

    @Override
    public ConfigValue createNewValue(String valueName) {
        ConfigValue value = new ConfigValue(valueName);
        value.setActive();
        this.valuesList.add(value);
        return value;
    }

    @Override
    public ConfigBlock createNewValue(String valueName, String dataType, String currentValue, String defaultValue) {
        ConfigValue value = new ConfigValue(valueName);
        value.setActive();
        value.setDataType(dataType);
        value.setCurrentValue(currentValue);
        value.setDefaultValue(defaultValue);
        this.valuesList.add(value);
        return this;
    }

    @Override
    public ConfigValue getValueByName(String valueName) {
        for (ConfigValue value : this.valuesList) {
            if (!value.getName().equals(valueName)) continue;
            return value;
        }
        return null;
    }

    public float getHardness() {
        for (ConfigValue value : this.valuesList) {
            if (!value.getName().equals(this.hardness.getName())) continue;
            return Float.parseFloat(value.getCurrentValue());
        }
        return 0.0f;
    }

    public ConfigBlock setHardness(float hardness) {
        this.hardness.setActive().setDataType("@F").setCurrentValue("" + hardness).setDefaultValue("" + hardness);
        return this;
    }

    public float getResistance() {
        for (ConfigValue value : this.valuesList) {
            if (!value.getName().equals(this.resistance.getName())) continue;
            return Float.parseFloat(value.getCurrentValue());
        }
        return 0.0f;
    }

    public ConfigBlock setResistance(float resistance) {
        this.resistance.setActive().setDataType("@F").setCurrentValue("" + resistance).setDefaultValue("" + resistance);
        return this;
    }

    public float getLightValue() {
        for (ConfigValue value : this.valuesList) {
            if (!value.getName().equals(this.lightValue.getName())) continue;
            return Float.parseFloat(value.getCurrentValue());
        }
        return 0.0f;
    }

    public ConfigBlock setLightValue(float lightValue) {
        this.lightValue.setActive().setDataType("@F").setCurrentValue("" + lightValue).setDefaultValue("" + lightValue);
        return this;
    }

    public int getHarvestLevel() {
        for (ConfigValue value : this.valuesList) {
            if (!value.getName().equals(this.harvestLevel.getName())) continue;
            return Integer.parseInt(value.getCurrentValue());
        }
        return 0;
    }

    public ConfigBlock setHarvestLevel(int harvestLevel) {
        this.harvestLevel.setActive().setDataType("@I").setCurrentValue("" + harvestLevel).setDefaultValue("" + harvestLevel);
        return this;
    }

    public String getHarvestTool() {
        for (ConfigValue value : this.valuesList) {
            if (!value.getName().equals(this.harvestTool.getName())) continue;
            return value.getCurrentValue();
        }
        return "";
    }

    public ConfigBlock setHarvestTool(String harvestTool) {
        this.harvestTool.setActive().setDataType("@S").setCurrentValue(harvestTool).setDefaultValue(harvestTool);
        return this;
    }

    public CreativeTabs getCreativeTab() {
        for (ConfigValue value : this.valuesList) {
            if (!value.getName().equals(this.creativeTab.getName()) || !ContentRegistry.doesTabExist(value.getCurrentValue())) continue;
            return ContentRegistry.getTab(value.getCurrentValue());
        }
        return null;
    }

    public ConfigBlock setCreativeTab(String tabName) {
        this.creativeTab.setActive().setDataType("@S").setCurrentValue(tabName).setDefaultValue(tabName);
        return this;
    }

    public int getSpawnRate() {
        for (ConfigValue value : this.valuesList) {
            if (!value.getName().equals(this.spawnRate.getName())) continue;
            return Integer.parseInt(value.getCurrentValue());
        }
        return 0;
    }

    public ConfigBlock setSpawnRate(int spawnRate) {
        this.spawnRate.setActive().setDataType("@I").setCurrentValue("" + spawnRate).setDefaultValue("" + spawnRate);
        return this;
    }

    public int getVeinSize() {
        for (ConfigValue value : this.valuesList) {
            if (!value.getName().equals(this.veinSize.getName())) continue;
            return Integer.parseInt(value.getCurrentValue());
        }
        return 0;
    }

    public ConfigBlock setVeinSize(int veinSize) {
        this.veinSize.setActive().setDataType("@I").setCurrentValue("" + veinSize).setDefaultValue("" + veinSize);
        return this;
    }

    public int getMinHeight() {
        for (ConfigValue value : this.valuesList) {
            if (!value.getName().equals(this.minHeight.getName())) continue;
            return Integer.parseInt(value.getCurrentValue());
        }
        return 0;
    }

    public ConfigBlock setMinHeight(int minHeight) {
        this.minHeight.setActive().setDataType("@I").setCurrentValue("" + minHeight).setDefaultValue("" + minHeight);
        return this;
    }

    public int getMaxHeight() {
        for (ConfigValue value : this.valuesList) {
            if (!value.getName().equals(this.maxHeight.getName())) continue;
            return Integer.parseInt(value.getCurrentValue());
        }
        return 0;
    }

    public ConfigBlock setMaxHeight(int maxHeight) {
        this.maxHeight.setActive().setDataType("@I").setCurrentValue("" + maxHeight).setDefaultValue("" + maxHeight);
        return this;
    }

    public boolean getDropItem() {
        for (ConfigValue value : this.valuesList) {
            if (!value.getName().equals(this.dropItem.getName())) continue;
            return Boolean.parseBoolean(value.getCurrentValue());
        }
        return false;
    }

    public ConfigBlock setDropItem(boolean dropItem) {
        this.dropItem.setActive().setDataType("@B").setCurrentValue("" + dropItem).setDefaultValue("" + dropItem);
        return this;
    }

    public Item getItemToDrop() {
        for (ConfigValue value : this.valuesList) {
            if (!value.getName().equals(this.itemToDrop.getName())) continue;
            return (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(value.getCurrentValue()));
        }
        return null;
    }

    public ConfigBlock setItemToDrop(Item itemToDrop) {
        this.itemToDrop.setActive().setDataType("@S").setCurrentValue("" + Item.field_150901_e.func_177774_c((Object)itemToDrop)).setDefaultValue("" + Item.field_150901_e.func_177774_c((Object)itemToDrop));
        return this;
    }

    public ConfigBlock setItemToDrop(String itemToDrop) {
        this.itemToDrop.setActive().setDataType("@S").setCurrentValue(itemToDrop).setDefaultValue(itemToDrop);
        return this;
    }

    public int getQuantityToDrop() {
        for (ConfigValue value : this.valuesList) {
            if (!value.getName().equals(this.quantityToDrop.getName())) continue;
            return Integer.parseInt(value.getCurrentValue());
        }
        return 0;
    }

    public ConfigBlock setQuantityToDrop(int quantityToDrop) {
        this.quantityToDrop.setActive().setDataType("@I").setCurrentValue("" + quantityToDrop).setDefaultValue("" + quantityToDrop);
        return this;
    }

    public Material getBlockMaterial() {
        for (ConfigValue value : this.valuesList) {
            if (!value.getName().equals(this.blockMaterial.getName())) continue;
            try {
                Class<Material> aClass = Material.class;
                Field field = aClass.getField(value.getCurrentValue());
                Material matInst = new Material(null);
                Object matObj = field.get(matInst);
                return (Material)matObj;
            }
            catch (Exception e) {
                LogHelper.verbose("Material entered for block " + this.getName() + " is invalid. \"" + value.getCurrentValue() + "\" is not a valid material");
            }
        }
        return Material.field_151576_e;
    }

    public ConfigBlock setBlockMaterial(String materialName) {
        this.blockMaterial.setActive().setDataType("@S").setCurrentValue(materialName).setDefaultValue(materialName);
        return this;
    }

    public Block.SoundType getSoundType() {
        for (ConfigValue value : this.valuesList) {
            if (!value.getName().equals(this.soundType.getName())) continue;
            try {
                String str = "soundType" + value.getCurrentValue().toUpperCase().charAt(0) + value.getCurrentValue().substring(1);
                Class<Block> aClass = Block.class;
                Field field = aClass.getField(str);
                Block.SoundType soundInst = new Block.SoundType(null, 0.0f, 0.0f);
                Object soundObj = field.get(soundInst);
                return (Block.SoundType)soundObj;
            }
            catch (Exception e) {
                LogHelper.verbose("SoundType entered for block " + this.getName() + " is invalid. \"" + value.getCurrentValue() + "\" is not a valid soundtype");
            }
        }
        return null;
    }

    public ConfigBlock setSoundType(String soundType) {
        this.soundType.setActive().setDataType("@S").setCurrentValue(soundType).setDefaultValue(soundType);
        return this;
    }

    public boolean getUnbreakable() {
        for (ConfigValue value : this.valuesList) {
            if (!value.getName().equals(this.unbreakable.getName())) continue;
            return Boolean.parseBoolean(value.getCurrentValue());
        }
        return false;
    }

    public ConfigBlock setUnbreakable(boolean unbreakable) {
        this.unbreakable.setActive().setDataType("@B").setCurrentValue("" + unbreakable).setDefaultValue("" + unbreakable);
        return this;
    }

    public boolean getFireSource() {
        for (ConfigValue value : this.valuesList) {
            if (!value.getName().equals(this.fireSource.getName())) continue;
            return Boolean.parseBoolean(value.getCurrentValue());
        }
        return false;
    }

    public ConfigBlock setFireSource(boolean fireSource) {
        this.fireSource.setActive().setDataType("@B").setCurrentValue("" + fireSource).setDefaultValue("" + fireSource);
        return this;
    }

    public boolean getIsLeaves() {
        for (ConfigValue value : this.valuesList) {
            if (!value.getName().equals(this.isLeaves.getName())) continue;
            return Boolean.parseBoolean(value.getCurrentValue());
        }
        return false;
    }

    public ConfigBlock setIsLeaves(boolean isLeaves) {
        this.isLeaves.setActive().setDataType("@B").setCurrentValue("" + isLeaves).setDefaultValue("" + isLeaves);
        return this;
    }

    public boolean getIsWood() {
        for (ConfigValue value : this.valuesList) {
            if (!value.getName().equals(this.isWood.getName())) continue;
            return Boolean.parseBoolean(value.getCurrentValue());
        }
        return false;
    }

    public ConfigBlock setIsWood(boolean isWood) {
        this.isWood.setActive().setDataType("@B").setCurrentValue("" + isWood).setDefaultValue("" + isWood);
        return this;
    }

    public boolean getBeaconBase() {
        for (ConfigValue value : this.valuesList) {
            if (!value.getName().equals(this.beaconBase.getName())) continue;
            return Boolean.parseBoolean(value.getCurrentValue());
        }
        return false;
    }

    public ConfigBlock setBeaconBase(boolean beaconBase) {
        this.beaconBase.setActive().setDataType("@B").setCurrentValue("" + beaconBase).setDefaultValue("" + beaconBase);
        return this;
    }
}

