/*
 * Decompiled with CFR 0.152.
 */
package alexndr.api.config;

import alexndr.api.config.types.ConfigEntry;
import alexndr.api.config.types.ConfigValue;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class ConfigWriter {
    private File file;
    private String modName = "";
    private List<ConfigEntry> entriesList = Lists.newArrayList();

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getModName() {
        return this.modName;
    }

    public void setModName(String modName) {
        this.modName = modName;
    }

    public void setEntriesList(List<ConfigEntry> entriesList) {
        this.entriesList = entriesList;
    }

    public void writeConfig() {
        try {
            ArrayList categoriesList = Lists.newArrayList();
            Element root = new Element("Configuration");
            Document doc = new Document(root);
            for (ConfigEntry o : this.entriesList) {
                Element category;
                ConfigEntry entry = o;
                if (!categoriesList.contains(entry.getCategory())) {
                    categoriesList.add(entry.getCategory());
                    category = new Element(entry.getCategory());
                    root.addContent(category);
                } else {
                    category = root.getChild(entry.getCategory());
                }
                Element type = new Element(entry.getCategory().charAt(entry.getCategory().length() - 1) == 's' ? entry.getCategory().substring(0, entry.getCategory().length() - 1) : entry.getCategory());
                type.setAttribute("Name", entry.getName());
                category.addContent(type);
                for (ConfigValue value : entry.getValuesList()) {
                    if (!value.isActive()) continue;
                    Element property = new Element(value.getName());
                    property.setText(value.getCurrentValue());
                    property.setAttribute("DataType", value.getDataType());
                    property.setAttribute("Default", value.getDefaultValue());
                    type.addContent(property);
                }
            }
            FileOutputStream out = new FileOutputStream(this.file);
            XMLOutputter serializer = new XMLOutputter(Format.getPrettyFormat().setIndent("\t"));
            serializer.output(doc, (OutputStream)out);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

