/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.gui.inventory;

import com.mrcrayfish.furniture.items.IMail;
import com.mrcrayfish.furniture.util.NBTHelper;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class InventoryPresent
extends InventoryBasic {
    protected EntityPlayer playerEntity;
    protected static ItemStack present;
    protected boolean reading = false;
    protected String uniqueID = "";

    public InventoryPresent(EntityPlayer player, ItemStack present) {
        super("Present", false, InventoryPresent.getInventorySize());
        this.playerEntity = player;
        InventoryPresent.present = present;
        if (!this.hasInventory()) {
            this.uniqueID = UUID.randomUUID().toString();
            this.createInventory();
        }
        this.loadInventory();
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (!this.reading) {
            this.saveInventory();
        }
    }

    public void func_174889_b(EntityPlayer player) {
        this.loadInventory();
    }

    public void func_174886_c(EntityPlayer player) {
        this.saveInventory();
    }

    protected static int getInventorySize() {
        return 4;
    }

    protected boolean hasInventory() {
        return NBTHelper.hasTag(present, "Present");
    }

    protected void createInventory() {
        this.writeToNBT();
    }

    protected void setNBT() {
        for (ItemStack itemStack : this.playerEntity.field_71071_by.field_70462_a) {
            NBTTagCompound nbt;
            if (itemStack == null || !(itemStack.func_77973_b() instanceof IMail) || (nbt = itemStack.func_77978_p()) == null || !nbt.func_74775_l("Present").func_74779_i("UniqueID").equals(this.uniqueID)) continue;
            itemStack.func_77982_d(present.func_77978_p());
            break;
        }
    }

    public void loadInventory() {
        this.readFromNBT();
    }

    public void saveInventory() {
        this.writeToNBT();
        this.setNBT();
    }

    public String getSender() {
        return NBTHelper.getString(present, "Author");
    }

    protected void readFromNBT() {
        this.reading = true;
        NBTTagCompound nbt = NBTHelper.getCompoundTag(present, "Present");
        if ("".equals(this.uniqueID)) {
            this.uniqueID = nbt.func_74779_i("UniqueID");
            if ("".equals(this.uniqueID)) {
                this.uniqueID = UUID.randomUUID().toString();
            }
        }
        NBTTagList itemList = (NBTTagList)NBTHelper.getCompoundTag(present, "Present").func_74781_a("Items");
        for (int i = 0; i < itemList.func_74745_c(); ++i) {
            NBTTagCompound slotEntry = itemList.func_150305_b(i);
            int j = slotEntry.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.func_70302_i_()) continue;
            this.func_70299_a(j, ItemStack.func_77949_a((NBTTagCompound)slotEntry));
        }
        this.reading = false;
    }

    protected void writeToNBT() {
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i) == null) continue;
            NBTTagCompound slotEntry = new NBTTagCompound();
            slotEntry.func_74774_a("Slot", (byte)i);
            this.func_70301_a(i).func_77955_b(slotEntry);
            itemList.func_74742_a((NBTBase)slotEntry);
        }
        NBTTagCompound inventory = new NBTTagCompound();
        inventory.func_74782_a("Items", (NBTBase)itemList);
        inventory.func_74778_a("UniqueID", this.uniqueID);
        NBTHelper.setCompoundTag(present, "Present", inventory);
    }
}

