/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.mods.fei.utils;

import code.elix_x.mods.fei.api.permission.FEIPermissionLevel;
import code.elix_x.mods.fei.api.utils.PermissionRequiredSyncedForFEIUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GameModeFEIUtil
extends PermissionRequiredSyncedForFEIUtil<WorldSettings.GameType> {
    public static final ResourceLocation[] icons = new ResourceLocation[]{new ResourceLocation("FEI", "textures/icons/survival.png"), new ResourceLocation("FEI", "textures/icons/creative.png"), new ResourceLocation("FEI", "textures/icons/adventure.png"), null};
    private FEIPermissionLevel permissionLevel;

    public GameModeFEIUtil() {
        super("Game Mode", (T[])new WorldSettings.GameType[]{WorldSettings.GameType.SURVIVAL, WorldSettings.GameType.CREATIVE, WorldSettings.GameType.ADVENTURE, WorldSettings.GameType.SPECTATOR});
    }

    public void setPermissionLevel(FEIPermissionLevel permissionLevel) {
        this.permissionLevel = permissionLevel;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public WorldSettings.GameType getCurrent() {
        return Minecraft.func_71410_x().field_71442_b.func_178889_l();
    }

    @Override
    public FEIPermissionLevel getPermissionLevel(WorldSettings.GameType t) {
        return this.permissionLevel;
    }

    @Override
    public String getDesc(WorldSettings.GameType type) {
        return StatCollector.func_74838_a((String)("fei.gui.override.grid.utils.gamemode." + type.name().toLowerCase()));
    }

    @Override
    public void onSelect(WorldSettings.GameType type, EntityPlayer player, boolean permission) {
        if (permission) {
            player.func_71033_a(type);
        }
    }

    @Override
    public ResourceLocation getTexture(WorldSettings.GameType type) {
        return icons[type.func_77148_a()];
    }

    @Override
    public String getText(WorldSettings.GameType type) {
        return EnumChatFormatting.BOLD + (type == WorldSettings.GameType.SPECTATOR ? "S" : "?");
    }
}

