/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.mods.fei.client.jeioverride;

import code.elix_x.excore.utils.client.gui.elements.IGuiElement;
import code.elix_x.excore.utils.reflection.AdvancedReflectionHelper;
import code.elix_x.mods.fei.api.gui.FEIGuiOverride;
import code.elix_x.mods.fei.api.gui.elements.IConfigurableFEIGuiElement;
import code.elix_x.mods.fei.api.gui.elements.INotDisableableFEIGuiElement;
import code.elix_x.mods.fei.api.gui.elements.ISaveableFEIGuiElement;
import code.elix_x.mods.fei.api.profile.Profile;
import code.elix_x.mods.fei.client.jeioverride.ItemListOverlayOverride;
import code.elix_x.mods.fei.client.jeioverride.JEIOverrideConfigurationGui;
import code.elix_x.mods.fei.config.FEIConfiguration;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import mezz.jei.GuiEventHandler;
import mezz.jei.Internal;
import mezz.jei.ItemFilter;
import mezz.jei.JeiRuntime;
import mezz.jei.JustEnoughItems;
import mezz.jei.ProxyCommonClient;
import mezz.jei.api.IItemRegistry;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.IRecipeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import mezz.jei.config.Config;
import mezz.jei.config.LocalizedConfiguration;
import mezz.jei.gui.ItemListOverlay;
import mezz.jei.util.Log;
import mezz.jei.util.StackHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

@JEIPlugin
public class JeiReflector
implements IModPlugin,
IGuiElement<FEIGuiOverride>,
INotDisableableFEIGuiElement,
ISaveableFEIGuiElement,
IConfigurableFEIGuiElement {
    public static final Gson gson = new Gson();
    private static final AdvancedReflectionHelper.AField<JeiRuntime, ItemListOverlay> itemListOverlay = new AdvancedReflectionHelper.AField(JeiRuntime.class, new String[]{"itemListOverlay"}).setAccessible(true).setFinal(false);
    private static final AdvancedReflectionHelper.AField<StackHelper, Boolean> uidCacheEnabled = new AdvancedReflectionHelper.AField(StackHelper.class, new String[]{"uidCacheEnabled"}).setAccessible(true);
    private static final AdvancedReflectionHelper.AField<ItemListOverlay, ItemFilter> itemFilter = new AdvancedReflectionHelper.AField(ItemListOverlay.class, new String[]{"itemFilter"}).setAccessible(true);
    private static final AdvancedReflectionHelper.AField<ItemListOverlay, List<IAdvancedGuiHandler<?>>> advancedGuiHandlers = new AdvancedReflectionHelper.AField(ItemListOverlay.class, new String[]{"advancedGuiHandlers"}).setAccessible(true);
    private static final AdvancedReflectionHelper.AField<ProxyCommonClient, List<IModPlugin>> plugins = new AdvancedReflectionHelper.AField(ProxyCommonClient.class, new String[]{"plugins"}).setAccessible(true);
    private static final AdvancedReflectionHelper.AField<ProxyCommonClient, GuiEventHandler> guiEventHandler = new AdvancedReflectionHelper.AField(ProxyCommonClient.class, new String[]{"guiEventHandler"}).setAccessible(true);
    private static final AdvancedReflectionHelper.AField<GuiEventHandler, ItemListOverlay> itemListOverlayG = new AdvancedReflectionHelper.AField(GuiEventHandler.class, new String[]{"itemListOverlay"}).setAccessible(true);
    private static final AdvancedReflectionHelper.AField<Config, File> jeiConfigurationDir = new AdvancedReflectionHelper.AField(Config.class, new String[]{"jeiConfigurationDir"}).setAccessible(true);
    private static final AdvancedReflectionHelper.AField<Config, LocalizedConfiguration> itemBlacklistConfig = new AdvancedReflectionHelper.AField(Config.class, new String[]{"itemBlacklistConfig"}).setAccessible(true);
    private static final AdvancedReflectionHelper.AField<Config, LocalizedConfiguration> searchColorsConfig = new AdvancedReflectionHelper.AField(Config.class, new String[]{"searchColorsConfig"}).setAccessible(true);
    private static final AdvancedReflectionHelper.AField<Configuration, File> file = new AdvancedReflectionHelper.AField(Configuration.class, new String[]{"file"}).setAccessible(true);
    private static final AdvancedReflectionHelper.AField<Configuration, Boolean> changed = new AdvancedReflectionHelper.AField(Configuration.class, new String[]{"changed"}).setAccessible(true);
    public boolean canGiveItems;
    public boolean canDeleteItemsAboveItemsList;
    public boolean moveSearchFieldToCenter;
    public int searchFieldWidth;
    public int searchFieldHeight;

    public JeiReflector() {
        FEIGuiOverride.addElement(this);
    }

    public void register(IModRegistry registry) {
    }

    public void onRuntimeAvailable(final IJeiRuntime jeiRuntime) {
        new Thread(){

            @Override
            public void run() {
                while (((Boolean)uidCacheEnabled.get((Object)Internal.getStackHelper())).booleanValue()) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException e) {}
                }
                ItemListOverlayOverride overlay = new ItemListOverlayOverride((ItemFilter)itemFilter.get((Object)((ItemListOverlay)jeiRuntime.getItemListOverlay())), (List)advancedGuiHandlers.get((Object)((ItemListOverlay)jeiRuntime.getItemListOverlay())), JeiReflector.this.canGiveItems, JeiReflector.this.canDeleteItemsAboveItemsList, JeiReflector.this.moveSearchFieldToCenter, JeiReflector.this.searchFieldWidth, JeiReflector.this.searchFieldHeight);
                itemListOverlay.set((Object)((JeiRuntime)jeiRuntime), (Object)overlay);
                itemListOverlayG.set(guiEventHandler.get((Object)((ProxyCommonClient)JustEnoughItems.getProxy())), (Object)overlay);
                Iterator iterator = ((List)plugins.get((Object)((ProxyCommonClient)JustEnoughItems.getProxy()))).iterator();
                while (iterator.hasNext()) {
                    IModPlugin plugin = (IModPlugin)iterator.next();
                    if (plugin == JeiReflector.this) continue;
                    try {
                        plugin.onRuntimeAvailable(jeiRuntime);
                    }
                    catch (RuntimeException e) {
                        Log.error((String)"Mod plugin failed: {}", (Object[])new Object[]{plugin.getClass(), e});
                        iterator.remove();
                    }
                }
            }
        }.start();
    }

    @Override
    public String getUnlocalizedName() {
        return "fei.gui.override.jei.override";
    }

    @Override
    public void openConfigGui(GuiScreen parent, FEIGuiOverride fei) {
        parent.field_146297_k.func_147108_a((GuiScreen)new JEIOverrideConfigurationGui(parent, this));
    }

    @Override
    public void load(Profile profile, JsonObject json) {
        Configuration world;
        JsonData data = (JsonData)gson.fromJson((JsonElement)json, JsonData.class);
        this.canGiveItems = data.canGiveItems;
        this.canDeleteItemsAboveItemsList = data.canDeleteItemsAboveItemsList;
        this.moveSearchFieldToCenter = data.moveSearchFieldToCenter;
        this.searchFieldWidth = data.searchFieldWidth;
        this.searchFieldHeight = data.searchFieldHeight;
        File jeiDir = new File(profile.getSaveDir(), "JEI");
        jeiDir.mkdir();
        jeiConfigurationDir.set(null, (Object)jeiDir);
        if (FEIConfiguration.loadJeiFromProfileConfig) {
            LocalizedConfiguration config = Config.getConfig();
            file.set((Object)config, (Object)new File(jeiDir, config.getConfigFile().getName()));
            changed.set((Object)config, (Object)true);
            config.load();
        }
        if (FEIConfiguration.loadJeiFromProfileWorld && (world = Config.getWorldConfig()) != null) {
            file.set((Object)world, (Object)new File(jeiDir, world.getConfigFile().getName()));
            changed.set((Object)world, (Object)true);
            world.load();
        }
        if (FEIConfiguration.loadJeiFromProfileBlacklist) {
            LocalizedConfiguration blacklist = (LocalizedConfiguration)itemBlacklistConfig.get(null);
            file.set((Object)blacklist, (Object)new File(jeiDir, blacklist.getConfigFile().getName()));
            changed.set((Object)blacklist, (Object)true);
            blacklist.load();
        }
        if (FEIConfiguration.loadJeiFromProfileColors) {
            LocalizedConfiguration colors = (LocalizedConfiguration)searchColorsConfig.get(null);
            file.set((Object)colors, (Object)new File(jeiDir, colors.getConfigFile().getName()));
            changed.set((Object)colors, (Object)true);
            colors.load();
        }
        MinecraftForge.EVENT_BUS.post((Event)new ConfigChangedEvent.OnConfigChangedEvent("JEI", "", Minecraft.func_71410_x().field_71441_e != null, false));
    }

    @Override
    public JsonObject save(Profile profile) {
        JsonData data = new JsonData();
        data.canGiveItems = this.canGiveItems;
        data.canDeleteItemsAboveItemsList = this.canDeleteItemsAboveItemsList;
        data.moveSearchFieldToCenter = this.moveSearchFieldToCenter;
        data.searchFieldWidth = this.searchFieldWidth;
        data.searchFieldHeight = this.searchFieldHeight;
        return gson.toJsonTree((Object)data).getAsJsonObject();
    }

    public String getName() {
        return "JEI Override";
    }

    public void openGui(FEIGuiOverride handler, GuiScreen gui) {
    }

    public void initGui(FEIGuiOverride handler, GuiScreen gui) {
    }

    public void drawGuiPre(FEIGuiOverride handler, GuiScreen gui, int mouseX, int mouseY) {
    }

    public void drawBackground(FEIGuiOverride handler, GuiScreen gui, int mouseX, int mouseY) {
    }

    public void drawGuiPost(FEIGuiOverride handler, GuiScreen gui, int mouseX, int mouseY) {
    }

    public void drawGuiPostPost(FEIGuiOverride handler, GuiScreen gui, int mouseX, int mouseY) {
    }

    public boolean handleKeyboardEvent(FEIGuiOverride handler, GuiScreen gui, boolean down, int key, char c) {
        return false;
    }

    public boolean handleMouseEvent(FEIGuiOverride handler, GuiScreen gui, int mouseX, int mouseY, boolean down, int key) {
        return false;
    }

    public boolean handleMouseEvent(FEIGuiOverride handler, GuiScreen gui, int mouseX, int mouseY, int dWheel) {
        return false;
    }

    public void onJeiHelpersAvailable(IJeiHelpers jeiHelpers) {
    }

    public void onItemRegistryAvailable(IItemRegistry itemRegistry) {
    }

    public void onRecipeRegistryAvailable(IRecipeRegistry recipeRegistry) {
    }

    public static class JsonData {
        private boolean canGiveItems;
        private boolean canDeleteItemsAboveItemsList;
        private boolean moveSearchFieldToCenter;
        private int searchFieldWidth;
        private int searchFieldHeight;

        private JsonData() {
        }
    }
}

