/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.mods.fei.client.gui.element;

import code.elix_x.excore.utils.client.gui.elements.GridGuiElement;
import code.elix_x.excore.utils.client.gui.elements.IGuiElement;
import code.elix_x.excore.utils.client.gui.elements.IGuiElementsHandler;
import code.elix_x.excore.utils.color.RGBA;
import code.elix_x.mods.fei.api.gui.FEIGuiOverride;
import code.elix_x.mods.fei.api.gui.elements.IConfigurableFEIGuiElement;
import code.elix_x.mods.fei.api.gui.elements.ISaveableFEIGuiElement;
import code.elix_x.mods.fei.api.profile.Profile;
import code.elix_x.mods.fei.api.utils.IFEIUtil;
import code.elix_x.mods.fei.client.gui.FEIUtilsGridSettingsGui;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import org.apache.commons.lang3.ArrayUtils;
import org.lwjgl.util.Rectangle;

public class FEIUtilsGrid
extends GridGuiElement<FEIGuiOverride>
implements ISaveableFEIGuiElement,
IConfigurableFEIGuiElement {
    public static final Gson gson = new Gson();
    private Map<String, FEIUtilsGridElement> allElements = new HashMap<String, FEIUtilsGridElement>();
    private FEIUtilsGridElement currentSelected;
    public RGBA textColor = new RGBA(255, 255, 255, 255);
    public boolean tooltipBackground = false;

    public FEIUtilsGrid() {
        super("FEI Utils Grid", 0, 0, 20, 20, 5, 2, 2, 2, new RGBA(0, 0, 0, 0));
    }

    protected void addElement(FEIUtilsGridElement element) {
        this.allElements.put(element.getName(), element);
    }

    public void addElement(IFEIUtil e) {
        this.addElement(new FEIUtilsGridElement(e));
    }

    public FEIUtilsGridElement getElement(int x, int y) {
        return (FEIUtilsGridElement)super.getElement(x, y);
    }

    public Collection<FEIUtilsGridElement> getAllElements() {
        return this.allElements.values();
    }

    @Override
    public void load(Profile profile, JsonObject json) {
        JsonData data = (JsonData)gson.fromJson((JsonElement)json, JsonData.class);
        this.xPos = data.xPos;
        this.yPos = data.yPos;
        this.elementsX = data.elementsX;
        this.elementsY = data.elementsY;
        this.borderX = data.borderX;
        this.borderY = data.borderY;
        this.backgroundColor = data.backgroundColor;
        this.textColor = data.textColor;
        this.tooltipBackground = data.tooltipBackground;
        this.reInitElements();
        for (Map.Entry e : data.utils.entrySet()) {
            FEIUtilsGridElement element = this.allElements.get(e.getKey());
            if (element == null) continue;
            element.currentPropertyIndex = ((JsonData.JsonGridElementData)e.getValue()).currentPropertyIndex;
            element.updateCurrentProperty();
            this.addElement(element, ((JsonData.JsonGridElementData)e.getValue()).x, ((JsonData.JsonGridElementData)e.getValue()).y);
        }
    }

    @Override
    public JsonObject save(Profile profile) {
        JsonData data = new JsonData();
        data.xPos = this.xPos;
        data.yPos = this.yPos;
        data.elementsX = this.elementsX;
        data.elementsY = this.elementsY;
        data.borderX = this.borderX;
        data.borderY = this.borderY;
        data.backgroundColor = this.backgroundColor;
        data.textColor = this.textColor;
        data.tooltipBackground = this.tooltipBackground;
        for (int x = 0; x < this.getElementsX(); ++x) {
            for (int y = 0; y < this.elementsY; ++y) {
                FEIUtilsGridElement element = this.getElement(x, y);
                if (element == null) continue;
                data.utils.put(element.getName(), new JsonData.JsonGridElementData(x, y, element.currentPropertyIndex));
            }
        }
        return gson.toJsonTree((Object)data).getAsJsonObject();
    }

    @Override
    public String getUnlocalizedName() {
        return "fei.gui.override.grid.utils";
    }

    @Override
    public void openConfigGui(GuiScreen parent, FEIGuiOverride fei) {
        parent.field_146297_k.func_147108_a((GuiScreen)new FEIUtilsGridSettingsGui(parent, this));
    }

    public void drawGuiPost(FEIGuiOverride fei, GuiScreen gui, int mouseX, int mouseY) {
        super.drawGuiPost((IGuiElementsHandler)fei, gui, mouseX, mouseY);
        if (gui.func_146272_n() && (this.inside(mouseX, mouseY) || this.currentSelected != null && this.currentSelected.isInsideExtended(this.calcAbsX(this.getX(this.currentSelected)), this.calcAbsY(this.getY(this.currentSelected)), mouseX, mouseY))) {
            this.drawTooltip(gui.field_146297_k.field_71466_p, mouseX, mouseY, true, true, 4, this.textColor, this.tooltipBackground, true, new String[]{"fei.gui.override.grid.utils.leftclick", "fei.gui.override.grid.utils.rightclick"});
        }
    }

    public boolean handleMouseEvent(FEIGuiOverride fei, GuiScreen gui, int mouseX, int mouseY, boolean down, int key) {
        if (this.currentSelected != null) {
            if (this.currentSelected.handleExtendedMouseEvent(fei, gui, this.calcAbsX(this.getX(this.currentSelected)), this.calcAbsY(this.getY(this.currentSelected)), mouseX, mouseY, down, key)) {
                fei.looseFocus();
                return true;
            }
            if (!this.currentSelected.isInsideExtended(this.calcAbsX(this.getX(this.currentSelected)), this.calcAbsY(this.getY(this.currentSelected)), mouseX, mouseY)) {
                this.currentSelected = null;
                fei.looseFocus();
                return true;
            }
        } else if (down && key == 1 && this.inside(mouseX, mouseY)) {
            this.currentSelected = this.getElement(this.calcLocalX(mouseX), this.calcLocalY(mouseY));
            if (this.currentSelected != null && this.currentSelected.canBeExtended()) {
                fei.setFocused((IGuiElement<FEIGuiOverride>)this);
            } else {
                this.currentSelected = null;
            }
            return true;
        }
        return super.handleMouseEvent((IGuiElementsHandler)fei, gui, mouseX, mouseY, down, key);
    }

    public static class JsonData {
        private int xPos;
        private int yPos;
        private int elementsX;
        private int elementsY;
        private int borderX;
        private int borderY;
        private RGBA backgroundColor;
        private RGBA textColor;
        private boolean tooltipBackground;
        private Map<String, JsonGridElementData> utils = new HashMap<String, JsonGridElementData>();

        private JsonData() {
        }

        public static class JsonGridElementData {
            private int x;
            private int y;
            private int currentPropertyIndex;

            private JsonGridElementData() {
            }

            private JsonGridElementData(int x, int y, int currentPropertyIndex) {
                this.x = x;
                this.y = y;
                this.currentPropertyIndex = currentPropertyIndex;
            }
        }
    }

    public class FEIUtilsGridElement
    extends GridGuiElement.GridElement {
        public IFEIUtil util;
        public int currentPropertyIndex;
        public IFEIUtil.IFEIUtilProperty currentProperty;

        public FEIUtilsGridElement(IFEIUtil util) {
            super((GridGuiElement)FEIUtilsGrid.this);
            this.util = util;
        }

        public String getName() {
            return this.util.getName();
        }

        public IFEIUtil.IFEIUtilProperty[] getAllProperties() {
            return this.util.getAllProperties();
        }

        public int getPropertiesCount() {
            return this.getAllProperties().length;
        }

        public boolean canBeExtended() {
            return this.getPropertiesCount() > 1;
        }

        public void updateCurrentProperty() {
            this.currentProperty = this.getAllProperties()[this.currentPropertyIndex];
        }

        public void updateCurrentPropertyIndex() {
            this.currentPropertyIndex = ArrayUtils.indexOf((Object[])this.getAllProperties(), (Object)this.currentProperty);
        }

        public int getNextPropertyIndex() {
            return (this.currentPropertyIndex + 1) % this.getPropertiesCount();
        }

        public IFEIUtil.IFEIUtilProperty getNextProperty() {
            return this.getAllProperties()[this.getNextPropertyIndex()];
        }

        public boolean isInsideExtended(int relX, int relY, int mouseX, int mouseY) {
            return relX <= mouseX && mouseX <= relX + FEIUtilsGrid.this.elementX && relY <= mouseY && mouseY <= relY + this.getPropertiesCount() * (FEIUtilsGrid.this.elementY + FEIUtilsGrid.this.borderY) - FEIUtilsGrid.this.borderY;
        }

        public void initGui(FEIGuiOverride fei, GuiScreen gui, int relX, int relY) {
            this.currentProperty = this.util.getCurrentProperty();
            if (this.currentProperty != null) {
                this.updateCurrentPropertyIndex();
            } else {
                this.updateCurrentProperty();
            }
        }

        public void drawGuiPost(FEIGuiOverride fei, GuiScreen gui, int relX, int relY, int mouseX, int mouseY) {
            if (this != FEIUtilsGrid.this.currentSelected) {
                IFEIUtil.IFEIUtilProperty prop = this.getNextProperty();
                GuiButtonExt button = new GuiButtonExt(0, relX, relY, FEIUtilsGrid.this.elementX, FEIUtilsGrid.this.elementY, prop.getTexture() != null ? "" : prop.getText());
                button.field_146124_l = prop.isEnabled();
                button.func_146112_a(gui.field_146297_k, mouseX, mouseY);
                if (prop.getTexture() != null) {
                    gui.field_146297_k.func_110434_K().func_110577_a(prop.getTexture());
                    FEIUtilsGrid.this.drawTexturedRect(new Rectangle(relX + 2, relY + 2, FEIUtilsGrid.this.elementX - 4, FEIUtilsGrid.this.elementY - 4), new Rectangle(0, 0, 16, 16), 16, 16);
                }
            }
        }

        public void drawGuiPostPost(FEIGuiOverride fei, GuiScreen gui, int relX, int relY, int mouseX, int mouseY) {
            if (this == FEIUtilsGrid.this.currentSelected) {
                if (FEIUtilsGrid.this.backgroundColor.a > 0) {
                    GuiScreen.func_73734_a((int)(relX - FEIUtilsGrid.this.borderX), (int)(relY - FEIUtilsGrid.this.borderY), (int)(relX + FEIUtilsGrid.this.elementX + FEIUtilsGrid.this.borderX), (int)(relY + this.getPropertiesCount() * (FEIUtilsGrid.this.elementY + FEIUtilsGrid.this.borderY)), (int)FEIUtilsGrid.this.backgroundColor.argb());
                }
                for (int i = 0; i < this.getPropertiesCount(); ++i) {
                    IFEIUtil.IFEIUtilProperty prop = this.getAllProperties()[i];
                    int y = relY + i * (FEIUtilsGrid.this.elementY + FEIUtilsGrid.this.borderY);
                    GuiButtonExt button = new GuiButtonExt(0, relX, y, FEIUtilsGrid.this.elementX, FEIUtilsGrid.this.elementY, prop.getTexture() != null ? "" : prop.getText());
                    button.field_146124_l = prop.isEnabled();
                    button.func_146112_a(gui.field_146297_k, mouseX, mouseY);
                    if (prop.getTexture() != null) {
                        gui.field_146297_k.func_110434_K().func_110577_a(prop.getTexture());
                        FEIUtilsGrid.this.drawTexturedRect(new Rectangle(relX + 2, y + 2, FEIUtilsGrid.this.elementX - 4, FEIUtilsGrid.this.elementY - 4), new Rectangle(0, 0, 16, 16), 16, 16);
                    }
                    if (!button.func_146115_a()) continue;
                    FEIUtilsGrid.this.drawTooltip(gui.field_146297_k.field_71466_p, mouseX, mouseY, false, true, 0, FEIUtilsGrid.this.textColor, FEIUtilsGrid.this.tooltipBackground, false, new String[]{prop.getDesc()});
                }
            } else if (this.inside(relX, relY, mouseX, mouseY)) {
                FEIUtilsGrid.this.drawTooltip(gui.field_146297_k.field_71466_p, mouseX, mouseY, false, true, 0, FEIUtilsGrid.this.textColor, FEIUtilsGrid.this.tooltipBackground, false, new String[]{this.getNextProperty().getDesc()});
            }
        }

        public boolean handleExtendedMouseEvent(FEIGuiOverride fei, GuiScreen gui, int relX, int relY, int mouseX, int mouseY, boolean down, int key) {
            if (this.isInsideExtended(relX, relY, mouseX, mouseY) && down && key == 0) {
                int i = (int)((float)(mouseY - relY) / (float)(FEIUtilsGrid.this.borderY + this.getPropertiesCount() * (FEIUtilsGrid.this.elementY + FEIUtilsGrid.this.borderY)) * (float)this.getPropertiesCount());
                if (this.getAllProperties()[i].isEnabled()) {
                    this.currentPropertyIndex = i;
                    this.updateCurrentProperty();
                    this.currentProperty.onSelect();
                    FEIUtilsGrid.this.currentSelected = null;
                    return true;
                }
            }
            return false;
        }

        public boolean handleMouseEvent(FEIGuiOverride fei, GuiScreen gui, int relX, int relY, int mouseX, int mouseY, boolean down, int key) {
            if (this.inside(relX, relY, mouseX, mouseY) && down) {
                if (key == 0) {
                    if (this.getNextProperty().isEnabled()) {
                        this.currentPropertyIndex = this.getNextPropertyIndex();
                        this.updateCurrentProperty();
                        this.currentProperty.onSelect();
                        return true;
                    }
                } else if (key == 1) {
                    FEIUtilsGrid.this.currentSelected = this;
                    return true;
                }
            }
            return false;
        }
    }
}

